package org.msh.etbm.services.mobile.sync;

import org.jboss.seam.Component;
import org.msh.etbm.services.mobile.SyncDataConsumer;
import org.msh.etbm.services.mobile.SynchronizationException;
import org.msh.etbm.services.mobile.model.HasId;
import org.msh.tb.application.SystemErrorDispatcher;
import org.msh.tb.entities.ErrorLog;
import org.msh.tb.entities.Tbunit;
import org.msh.tb.entities.UserLogin;
import org.msh.tb.login.UserSession;
import org.msh.utils.ObjectUtils;
import org.msh.utils.TransactionalBatchComponent;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Created by rmemoria on 5/9/17.
 */
public class TransactionalBatchIterator extends TransactionalBatchComponent {

    private List list;

    private Tbunit unit;

    private int index;

    private Class<? extends SyncDataConsumer> consumerClass;

    private Map<String, Object> keys = new HashMap<String, Object>();

    @Override
    protected boolean executeIteration() throws Exception {
        Object clidata = list.get(index);
        try {
            SyncDataConsumer consumer = ObjectUtils.newInstance(consumerClass);
            Object res = consumer.consume(unit, clidata);
            addToKeys(clidata, res);
        } catch (Exception e) {
            String msg = "Synchronization error: " + e.getMessage() + ", data = " +
                    clidata.toString();

            SynchronizationException exception = new SynchronizationException(msg, e);
            registerSynchronizationError(exception);
            throw exception;
        }

        index++;
        return index < list.size() ? true : false;
    }

    /**
     * Add the result of the consumer object to the list of keys generated
     * @param clidata
     * @param consumeResult
     */
    private void addToKeys(Object clidata, Object consumeResult) {
        if (consumeResult == null) {
            return;
        }

        if (!(clidata instanceof HasId)) {
            return;
        }

        Integer id = ((HasId) clidata).getId();
        if (id == null) {
            return;
        }

        keys.put(id.toString(), consumeResult);
    }

    public boolean execute(Tbunit unit, List list, Class<? extends SyncDataConsumer> consClass) {
        if (list.isEmpty()) {
            return false;
        }
        this.unit = unit;
        this.list = list;
        this.consumerClass = consClass;
        index = 0;

        return super.execute();
    }

    private void registerSynchronizationError(Exception e) {
        SystemErrorDispatcher dispatcher = (SystemErrorDispatcher) Component.getInstance("systemErrorDispatcher");

        UserLogin userLogin = UserSession.getUserLogin();
        dispatcher.dispatch(e, userLogin, "REST API", "not available");
    }

    public Map<String, Object> getKeys() {
        return keys;
    }
}
